﻿<?LassoScript
/*
This demo illustrates how to draw different kinds of graphics on a pdf page.
Graphics demonstrated are rectangles, circles and lines
Lasso can create graphics of type rectangles, lines, circles, curves and arcs.
They are placed based on a grid that starts in the lower left of the page.

Author: Jolle Carlestam
Prepared for the Lasso Developer Conference in Chicago 2008
Use and alter freely but please keep a reference to where you found it
*/

//First set some vars holding basic data.
var('pagetype' = 'A4',
	'pageheight' = 842, // points
	'pagewidth' = 595);

// If you prefer US-Letter sized paper uncomment this section
/*
var('pagetype' = 'LETTER',
	'pageheight' = 792, // points
	'pagewidth' = 612);

*/

// Create the pdf_doc object
var( 'pdf' = pdf_doc( -size = $pagetype, -nocompress));

// Place a rectangle that's not filled.
// Rectangles are drawn with coordinates (X, Y, Width, Height)
// starting from the lower left of the page.

$pdf -> rect( 100, $pageheight - 150, 200, 100);

// Place a rectangle that's filled.
$pdf -> rect( 350, $pageheight - 150, 200, 100, -fill);

// Place a rectangle that's not filled using rounded corners.
// The last param sets the corner radius.
$pdf -> rect( 100, $pageheight - 300, 200, 100, 3);

// Place a rectangle that's filled using rounded corners.
$pdf -> rect( 350, $pageheight - 300, 200, 100, 16, -fill);

// Place a circle that's not filled.
// Circles are drawn with coordinates (X, Y, R) starting from the
// lower left of the page. X and Y marks the center of the circle.
$pdf -> circle( 150, $pageheight - 400, 50);

// Place a circle that's filled.
$pdf -> circle( 400, $pageheight - 400, 50, -fill);

// Place a line.
// Lines are drawn with coordinates (X1, Y1, X2, Y2) where the first
//two marks the starting point and the last two the end.
$pdf -> line( 100, $pageheight - 550, 200, $pageheight - 500);

// Place a rectangle setting a line width first.
$pdf -> setlinewidth(2);
$pdf -> rect( 100, $pageheight - 680, 200, 100, 6);

// Place a circle setting a really thick line width.
$pdf -> setlinewidth(14);
$pdf -> setcolor('stroke', 'gray', 0.2);
$pdf -> circle( 400, $pageheight - 630, 50);

// Place a circle setting a semi thick line.
$pdf -> setlinewidth(4.5);
$pdf -> setcolor('stroke', 'RGB', 0,0.5,0);
$pdf -> circle( 420, $pageheight - 630, 50);

// Place a line setting a line width to a really thin value.
$pdf -> setlinewidth(0.1);
$pdf -> line( 100, $pageheight - 750, 200, $pageheight - 700);


// Finally close the pdf_doc and serve it
$pdf -> close;
pdf_serve( -content = $pdf, -file = 'demo4.pdf');

?>